import numpy as np

def get_orthogonal_vectors(n):
    # 生成n个随机向量
    random_vectors = np.random.rand(n, n)

    # 正交化过程
    orthogonal_vectors = []
    for i in range(n):
        vector = random_vectors[i]
        for j in range(i):
            vector -= np.dot(orthogonal_vectors[j], random_vectors[i]) * orthogonal_vectors[j]
        orthogonal_vectors.append(vector / np.linalg.norm(vector))

    return orthogonal_vectors

def stack_vectors(vectors):
    # 将向量组叠加成矩阵
    stacked_matrix = np.vstack(vectors)

    return stacked_matrix
def create_diagonal_matrix(n):
    # 计算间隔
    interval = 2 / n

    # 生成对角矩阵
    diagonal_values = np.arange(0, 2, interval)
    diagonal_matrix = np.diag(diagonal_values)

    return diagonal_matrix

n = 2708  # 或者你想要的向量维度
orthogonal_vectors = get_orthogonal_vectors(n)
stacked_matrix = stack_vectors(orthogonal_vectors)
diagonal_matrix = create_diagonal_matrix(n)
adj=stacked_matrix@diagonal_matrix@stacked_matrix.T

for vector in orthogonal_vectors:
    print(vector)